const express = require("express");
const path = require("path");
const bodyParser = require("body-parser");
const cookieParser = require("cookie-parser");
const routes = require("./routes");

const app = express();

app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
app.use(cookieParser());
app.use(express.json());
app.set("view engine", "ejs");

// Static files
app.use(express.static("public"));
app.use("assets/js", express.static(path.join(__dirname, "public/assets/js")));
app.use("asset/js", express.static(path.join(__dirname, "public/asset/js")));
app.use("assets/css", express.static(path.join(__dirname, "public/assets/css")));
app.use("asset/css", express.static(path.join(__dirname, "public/asset/css")));
app.use("assets/fonts", express.static(path.join(__dirname, "public/assets/fonts")));
app.use("assets/images", express.static(path.join(__dirname, "public/assets/images")));
app.use("asset/images", express.static(path.join(__dirname, "public/asset/images")));


// Use centralized routes
app.use("/", routes);

app.listen(5000, () => console.log("Server listening on port 5000"));
