# Avasya Properties 🏡

**A modern real estate web application built with Node.js.**  
Avasya helps users discover properties based on personalized preferences, including location, budget, and search behavior. Designed with accessibility and elegance in mind, it’s the perfect tool for buyers, renters, and agents.

---

## 🎨 Color Scheme

| Purpose              | Hex Code  | Sample     |
|----------------------|-----------|------------|
| Primary Blue         | `#1E3A8A` | ![#1E3A8A](https://via.placeholder.com/15/1E3A8A/000000?text=+) |
| Accent Coral         | `#F97316` | ![#F97316](https://via.placeholder.com/15/F97316/000000?text=+) |
| Soft Sky             | `#E0F2FE` | ![#E0F2FE](https://via.placeholder.com/15/E0F2FE/000000?text=+) |
| Slate Gray           | `#334155` | ![#334155](https://via.placeholder.com/15/334155/000000?text=+) |
| Cool White           | `#F8FAFC` | ![#F8FAFC](https://via.placeholder.com/15/F8FAFC/000000?text=+) |
| Emerald Green        | `#10B981` | ![#10B981](https://via.placeholder.com/15/10B981/000000?text=+) |

---

## 🚀 Features

- 🔍 Smart home search with filters and suggestions
- 🧠 Personalized recommendations
- 📍 Location-based search optimization
- 💬 Contact forms for agents and property owners
- 🖼️ High-quality property image galleries
- 👩‍💼 Admin panel for listings management

---

## ⚙️ Tech Stack

- **Backend**: Node.js, Express.js
- **Frontend**: HTML, Tailwind CSS (or React for dynamic UI)
- **Database**: MongoDB (or PostgreSQL/MySQL optional)
- **Templating**: EJS or React (based on your preference)
- **Authentication**: Passport.js or JWT
- **Map Integration**: Leaflet or Google Maps

---

## 📦 Getting Started

### Prerequisites

- Node.js >= 18.x
- npm or yarn
- MongoDB (local or cloud)

### Installation

```bash
# Clone the repository
git clone https://github.com/your-username/homenexa.git
cd homenexa

# Install dependencies
npm install

# Set up environment variables
cp .env.example .env
# Edit .env with your database and port configs


# Run the development server
npm run dev 

```

## 📦 Prisma Migration

```bash
npx prisma migrate dev --name init

```

## Reset the database 

```bash 
npx prisma migrate reset 
```